(*********************************************
TShip->TPolygonSprite

A spaceship class, suitable for games such as
asteroids.  Used the MoveThrust MoveProc.  Has
a fire method which can fire a TMissile sprite
based on its direction of rotation.
*********************************************)
unit Ship;

interface

uses

  SysUtils, WinTypes, WinProcs, Classes, Graphics, Controls, TurboSprite,
  Sprites, Missile, Grafix;

type

  TShip = class( TPolygonSprite )
  private
    Firing: boolean;
  protected
    procedure addVertices; override;
  public
    constructor CreateShip( Move: TMoveProc; col: byte );
    function fire: TMissile;
    procedure releaseFire;
  end;

implementation

constructor TShip.CreateShip( Move: TMoveProc; col: byte );
begin
  inherited CreatePolygonSprite( Move, col );
  Filled := true;
  MaximumSpeed := 4;
  Friction := 0.05;
end;

(*********************************************
This procedure must be overriden for all
sprites descended from TPolygonSprite
*********************************************)
procedure TShip.addVertices;
begin
  with poly do
  begin
    addPoint( Point(0, -7) );
    addPoint( Point(8, 14) );
    addPoint( Point(0, 12) ); { Thrust position! }
    addPoint( Point(-8, 14) );
  end;
end;

function TShip.fire: TMissile;
var
  m: TMissile;
  ptDest: TPoint;
begin
  Result := nil;
  if firing then
    Exit;
  firing := true;
  m := TMissile.CreateMissile( MoveTowardDestination, 100, Random(255) );
  ptDest.X := Position.X + Trunc( 100 * lkupCos[correctedAngle] );
  ptDest.Y := Position.Y - Trunc( 100 * lkupSin[IntToDegree(correctedAngle - 180)] );
  with m do
  begin
    Position := self.Position;
    Destination := ptDest;
    InitialSpeedX := self.SpeedX;
    InitialSpeedY := self.SpeedY;
  end;
  Result := m;
end;

procedure TShip.releaseFire;
begin
  firing := false;
end;

end.
